<?php
// eerste deel van de html, met melding en menu
?>
<!DOCTYPE html>
<html>
<head>
    <title>po php voorbeeld</title>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <!--
      hieronder staat wat voorbeeld style, van zowel html elementen (in dit geval body) als class (bijv menu_div)
      je mag ook met externe css bestanden werken
    -->
    <style>
        html, body {
            font-family: Arial, sans-serif;
            font-size: 1.0em;
            height: 100%;
            width: 100%;
            padding: 0px;
            margin: 0px;
        }

        table{
            border-spacing: 0;
            border-collapse: collapse;
        }
        td {
            border: 1px solid black;
            padding: 5px;
        }

        input{
            font-size: 1.0em;
            height: 22px;
        }

        .menu_div {
            background-color: black;
            padding: 10px;
            height: 15px;
            margin: 0px;
        }

        a{
            text-decoration: none;
            color: azure;
        }
        a:hover{
            color: green;
        }

        .main_div {
            background-color: azure;
            height: calc(100% - 55px);
            padding: 10px;
            margin: 0px;
        }

        .table_header{
            font-weight: bold;
        }

        .label_textbox{
            margin-bottom: 5px;
        }

        .button_div {
            background-color: yellow;
            border: 1px black solid;
            border-radius: 10px;
            cursor: pointer;
            padding: 8px;
            margin-top: 5px;
            display: inline-block;
        }
    </style>
    <!--
      hier kun je standaard javascript invoegen, die voor elke pagina van belang is
      in dit voorbeeld: als er in de pagina met een muis wordt geklikt, wordt de alert verborgen
      je mag ook met externe css bestanden werken
    -->
    <script>
        function verberg_alert() {
            if (document.getElementById('alert_div') != undefined) {
                document.getElementById('alert_div').style.display = 'none';
            }
        }
    </script>

</head>
<body onclick="verberg_alert()">
<!--
  hier kun je een eigen mooier menu invoegen
  je mag ipv gebruik van a href element ook andere html elementen gebruiken en onclick eraan toevoegen
  let er wel op dat je dan naar index.php?p= gaat en na de = moet je dus het id invullen, waarbij de php ook moet bestaan
  dus in het voorbeeld hieronder, id is motor, dus 2_motor.php bestaat: daarin wordt de content aangemaakt
-->
<div class="menu_div">
    <a href="index.php?p=home">Home</a> | <a href="index.php?p=motor">Motoren</a> | <a href="index.php?p=contact">Contact</a>
    |
  <?php
  // hier moet check plaatsvinden: als nog niet ingelogd, toon dan menu 'login', anders 'logout'
  if($_SESSION["user_id"] == ""){
    echo "<a href=\"index.php?p=login\">Login</a>";
  }else{
    echo "<a href=\"index.php?p=logout\">Logout</a>";
  }
  ?>
</div>
<?php
// als er een foutmelding of bevestiging moet worden gegeven, wordt die hier gedaan
if($alert_tekst != ""){
  echo "<div id=\"alert_div\" style=\"padding: 5px;background-color: $alert_kleur\">";
  echo $alert_tekst;
  echo "</div>";
}
?>
<!--
  in de volgende div wordt de content geprint, die via een view wordt aangemaakt (dus 2_xxx.php)
-->
<div class="main_div">
